@echo off
cls
rem
rem Quest Central for DB2 - Windows NT migration script
rem

prompt $g

set TRCFILE=migrateQC.trace
set SCRIPT=%0
set RC=0
set PARM1=source_directory
set PARM2=target_directory
set SRCHOME=%~1
set DESTHOME=%~2

rem 
rem Get host name to flesh out real source/destination information.
rem 

hostname>host.tmp

for /F "delims=" %%h in (host.tmp) do set HOSTNAME=%%h
set SRCDIR=%~1\%HOSTNAME%
set DESTDIR=%~2\%HOSTNAME%
del host.tmp

del %TRCFILE%
echo QCC30043I: %SCRIPT% Started.


rem
rem Check that the old and new Quest Central agent directories are specified.
rem
if "%~1" == "" (
   set  RC=1
   echo QCC30000E: %PARM1% parameter not specified.
   goto QMIGHELP
) 
if "%~2" == "" (
   set  RC=1
   echo QCC30000E: %PARM2% parameter not specified.
   goto QMIGHELP
)


rem
rem Check that the old and new Quest Central agent directories exist and are
rem directories.
rem
if not exist "%SRCHOME%" (
   set RC=1
   echo QCC30001E: %PARM1% directory specified does not exist or is not a directory.
   goto QMIGHELP
)
if not exist "%DESTHOME%" (
   set RC=1
   echo QCC30001E: %PARM2% directory specified does not exist or is not a directory.
   goto QMIGHELP
)
if not "%~a1" == "d--------" (
   set RC=1
   echo QCC30001E: %PARM1% directory specified does not exist or is not a directory.
   goto QMIGHELP
)
if not "%~a2" == "d--------" (
   set RC=1
   echo QCC30001E: %PARM2% directory specified does not exist or is not a directory.
   goto QMIGHELP
)


rem
rem Verify the two directories specified are not the same directory.
rem
if "%~f1" == "%~f2" (
   set  RC=2
   echo QCC30003E: The %PARM1% and %PARM2% directories must not be the same directory.
   goto QMIGEXIT
)
 
set SRCHOMEFULL=%~f1
set DESTHOMEFULL=%~f2


rem 
rem Check whether or not the host name was successfully obtained.
rem 
if "%HOSTNAME%" == "" (
   set  RC=6
   echo QCC30036E: Unable to obtain host name of local machine.
   goto QMIGEXIT 
)


rem 
rem Check whether or not the 'copy from' agent directory is host name based.
rem
if not exist "%SRCDIR%" (
   set SRCDIR=%SRCHOME%
   set ENVDIR=%SRCHOME%
) else (
   set ENVDIR=%SRCDIR%\env
)


rem
rem Insure that the origin agent directory structure exists.
rem 
set PARM=%SRCDIR%
if not exist "%SRCDIR%\Jobs" ( 
   set  RC=3
   echo QCC30004E: The %PARM1% does not contain a Jobs Directory.
   goto QCDIR_NVALID
)
if not exist "%SRCDIR%\Config" ( 
   set  RC=3
   echo QCC30005E: The %PARM1% does not contain a Config Directory.
   goto QCDIR_NVALID
)
if not exist "%SRCDIR%\Schedule.dat" ( 
   set  RC=3
   echo QCC30006E: The %PARM1% does not contain a Quest Job Scheduler file.
   goto QCDIR_NVALID
)
echo QCC30007I: The specified %PARM1% was confirmed as a valid Quest Central Agent home directory.


rem
rem If necessary, create the destination host name based directory structure .
rem
if exist "%DESTDIR%" (
   goto DESTDIR_EXISTS
)

set PARM=%PARM2%
set NEWDIR=%DESTDIR%
echo mkdir "%NEWDIR%">>%TRCFILE%
mkdir "%NEWDIR%"
if errorlevel 1 (
   goto QCDIR_CREATERR
)
set NEWDIR=%DESTDIR%\Config
echo mkdir "%NEWDIR%">>%TRCFILE%
mkdir "%NEWDIR%"
if errorlevel 1 (
   goto QCDIR_CREATERR
)
set NEWDIR=%DESTDIR%\Data
echo mkdir "%NEWDIR%">>%TRCFILE%
mkdir "%NEWDIR%"
if errorlevel 1 (
   goto QCDIR_CREATERR
)
set NEWDIR=%DESTDIR%\env
echo mkdir "%NEWDIR%">>%TRCFILE%
mkdir "%NEWDIR%"
if errorlevel 1 (
   goto QCDIR_CREATERR
)
set NEWDIR=%DESTDIR%\evm
echo mkdir "%NEWDIR%">>%TRCFILE%
mkdir "%NEWDIR%"
if errorlevel 1 (
   goto QCDIR_CREATERR
)
set NEWDIR=%DESTDIR%\Jobs
echo mkdir "%NEWDIR%">>%TRCFILE%
mkdir "%NEWDIR%"
if errorlevel 1 (
   goto QCDIR_CREATERR
)
set NEWDIR=%DESTDIR%\var
echo mkdir "%NEWDIR%">>%TRCFILE%
mkdir "%NEWDIR%"
if errorlevel 1 (
   goto QCDIR_CREATERR
)

:DESTDIR_EXISTS 


rem
rem Insure that the destination agent directory structure exists.
rem 
set PARM=%DESTDIR%
if not exist "%DESTDIR%\Jobs" ( 
   set  RC=4
   echo QCC30004E: The %PARM2% does not contain a Jobs Directory.
   goto QCDIR_NVALID
)
if not exist "%DESTDIR%\Config" ( 
   set  RC=4
   echo QCC30005E: The %PARM2% does not contain a Config Directory.
   goto QCDIR_NVALID
)
if not exist "%DESTDIR%\env" ( 
   set  RC=4
   echo QCC30006E: The %PARM2% does not contain an env Directory.
   goto QCDIR_NVALID
)


rem 
rem Minimally insure that the code base has been installed.
rem
if not exist "%DESTHOME%\QcAgent.exe" ( 
   set  RC=4
   echo QCC30008E: The %PARM2% does not contain an installed Quest Central Agent.
   goto QCDIR_NVALID
)
if not exist "%DESTHOME%\QcAgent2.dll" ( 
   set  RC=4
   echo QCC30008E: The %PARM2% does not contain an installed Quest Central Agent.
   goto QCDIR_NVALID
)
if not exist "%DESTHOME%\sed.exe" ( 
   set  RC=4
   echo QCC30008E: The %PARM2% does not contain an installed Quest Central Agent.
   goto QCDIR_NVALID
)
echo QCC30007I: The specified %PARM2% was confirmed as a valid Quest Central Agent home directory.


echo QCC30012I: Migrating configuration settings from %PARM1% to %PARM2%.
echo QCC30013I: %PARM1% set to %SRCDIR%.
echo QCC30014I: %PARM2% set to %DESTDIR%.

rem
rem Copy job scheduler files.
rem 
echo copy /Y "%SRCDIR%\schedule.*" "%DESTDIR%" >>%TRCFILE%
copy /Y "%SRCDIR%\schedule.*" "%DESTDIR%" >>%TRCFILE%
if errorlevel 1 (
   set RC=5
   echo QCC30012E: The %PARM1%'s Job Scheduler files unsuccessfully migrated to the %PARM2%.
   goto QMIGEXIT
) else (
   echo QCC30013I: The %PARM1%'s Job Scheduler files successfully migrated to the %PARM2%.
)


rem
rem Copy a few more pertinent files (if present).
rem 
if exist "%SRCDIR%\qcports.txt" (
   echo copy /Y "%SRCDIR%\qcports.txt" "%DESTDIR%">>%TRCFILE%
   copy /Y "%SRCDIR%\qcports.txt" "%DESTDIR%">>%TRCFILE%
)
if exist "%SRCDIR%\ScEAColumns.txt" (
   echo copy /Y "%SRCDIR%\ScEAColumns.txt" "%DESTDIR%">>%TRCFILE%
   copy /Y "%SRCDIR%\ScEAColumns.txt" "%DESTDIR%">>%TRCFILE%
)
if exist "%SRCDIR%\quest.conf" (
   echo copy /Y "%SRCDIR%\quest.conf" "%DESTDIR%">>%TRCFILE%
   copy /Y "%SRCDIR%\quest.conf" "%DESTDIR%">>%TRCFILE%
)


rem 
rem Now go after the Jobs, env, and Config directory contents
rem (in that order).
rem 


rem
rem Remove new Quest Central's Job directory to avoid overlap conflicts.
rem
echo del /q /s "%DESTDIR%\Jobs\*">>%TRCFILE%
del /q /s "%DESTDIR%\Jobs\*">>%TRCFILE%
if errorlevel 1 (
   set  RC=5
   echo QCC30014E: The %PARM2%'s Job Scheduler tree unsuccessfully removed.
   goto QMIGEXIT
) else (
   echo QCC30015I: The %PARM2%'s Job Scheduler tree successfully removed.
)

rem
rem Migrate previous version's Jobs directory to new version.
rem
echo dir "%SRCDIR%\Jobs\*">>%TRCFILE%
dir "%SRCDIR%\Jobs\*.env" >>%TRCFILE% 2>>&1
if errorlevel 1 (
   echo QCC30016W: No Job scheduler files exist in the %PARM1% to be migrated.
) else (
   echo xcopy /Y /e "%SRCDIR%\Jobs\*" "%DESTDIR%\Jobs">>%TRCFILE%
   xcopy /Y /e "%SRCDIR%\Jobs\*" "%DESTDIR%\Jobs">>%TRCFILE%
   if errorlevel 1 (
      set  RC=5
      echo QCC30017E: The %PARM1%'s Job Scheduler tree unsuccessfully migrated to the %PARM2%.
      goto QMIGEXIT
   ) else (
   echo QCC30018I: The %PARM1%'s Job Scheduler tree successfully migrated to the %PARM2%.
   )
)


rem
rem Do the same thing for the agent environment files...
rem
echo del /q /s "%DESTDIR%\env\*">>%TRCFILE%
del /q /s "%DESTDIR%\env\*">>%TRCFILE%
if errorlevel 1 (
   set  RC=5
   echo QCC30019E: The %PARM2%'s agent environment tree unsuccessfully removed.
   goto QMIGEXIT
) else (
   echo QCC30020I: The %PARM2%'s agent environment tree successfully removed.
)


rem
rem The ScAgent.env file is in QUESTHOME\config prior to QCDB2 4.5
rem
if exist "%SRCDIR%\Config\ScAgent.env" (
   echo copy /Y "%SRCDIR%\Config\ScAgent.env" "%DESTDIR%\env">>%TRCFILE%
   copy /Y "%SRCDIR%\Config\ScAgent.env" "%DESTDIR%\env">>%TRCFILE%	
)


echo dir "%ENVDIR%\*.env">>%TRCFILE%
dir "%ENVDIR%\*.env" >>%TRCFILE% 2>>&1
if errorlevel 1 (
   echo QCC30021W: No agent environment files exist in the %PARM1% to be migrated.
) else (
   echo copy /Y "%ENVDIR%\*.env" "%DESTDIR%\env">>%TRCFILE%
   copy /Y "%ENVDIR%\*.env" "%DESTDIR%\env">>%TRCFILE%
   if errorlevel 1 (
      set  RC=5
      echo QCC30022E: The %PARM1%'s agent environment files unsuccessfully migrated to the %PARM2%.
      goto QMIGEXIT
   ) else (
      echo QCC30023I: The %PARM1%'s agent environment files successfully migrated to the %PARM2%.
   )
)

rem
rem Go about translating home directory entries in all agent environment files.
rem If source directory is QCD 2.x or 3.x then adjust the EVM_PATH entry to point 
rem to QUESTHOME\HOST\evm instead of QUESTHOME\evm.
rem
echo Building sed.script for agent environment file translation.>>%TRCFILE%

echo s/%SRCHOMEFULL%/%DESTHOMEFULL%/Ig>tmp.script
sed -e "s/\\/\\\\/Ig" tmp.script>sed.script
if "%ENVDIR%" == "%SRCDIR%" (
  echo /^^EVM_PATH/ s/\\evm/\\%HOSTNAME%^&/Ig>>sed.script
)
type sed.script>>%TRCFILE%

set file="%DESTDIR%\env\*.env"
for %%f in ( %file% ) do ( 
   echo QCC30024I: Translating %%f agent environment configuration file to use the %PARM2%.
   echo sed -f sed.script "%%f" to tmp.file>>%TRCFILE%
   sed -f sed.script "%%f">tmp.file
   echo sed rc = %errorlevel% >>%TRCFILE%
   type tmp.file>>%TRCFILE%
   echo del "%%f">>%TRCFILE%
   del "%%f">>%TRCFILE%
   echo move tmp.file "%%f">>%TRCFILE%
   move tmp.file "%%f">>%TRCFILE%
)


rem
rem Do the same thing for the agent launcher configuration files...
rem
echo del /q /s "%DESTDIR%\Config\*">>%TRCFILE%
del /q /s "%DESTDIR%\Config\*">>%TRCFILE%
if errorlevel 1 (
   set  RC=5
   echo QCC30025E: The %PARM2%'s agent configuration tree unsuccessfully removed.
   goto QMIGEXIT
) else (
   echo QCC30026I: The %PARM2%'s agent configuration tree successfully removed.
)

echo dir "%SRCDIR%\Config\*">>%TRCFILE%
dir "%SRCDIR%\Config\*" >>%TRCFILE% 2>>&1
if errorlevel 1 (
   echo QCC30027W: No agent configuration files exist in the %PARM1% to be migrated.
) else (
   echo copy /Y "%SRCDIR%\Config\*" "%DESTDIR%\Config">>%TRCFILE%
   copy /Y "%SRCDIR%\Config\*" "%DESTDIR%\Config">>%TRCFILE%
   if errorlevel 1 (
      set  RC=6
      echo QCC30028E: The %PARM1%'s agent configuration files unsuccessfully migrated to the %PARM2%.
      goto QMIGEXIT
   ) else (
      echo QCC30029I: The %PARM1%'s agent configuration files successfully migrated to the %PARM2%.
   )
)
if "%ENVDIR%" == "%SRCDIR%" (
  echo del "%DESTDIR%\Config\*.env">>%TRCFILE%
  del "%DESTDIR%\Config\*.env"
)


rem
rem Go about translating home directory entries in all agent configuration files.
rem If source directory is QCD 2.x or 3.x then also adjust the following:
rem       agent home directory entry = QUESTHOME\HOSTNAME
rem       agent binary               = ..\EXECUTABLE
rem       agent env file (if any)    = env\ENVFILE
rem
echo Building sed.script for agent configuration file translation.>>%TRCFILE%

echo s/%SRCHOMEFULL%/%DESTHOMEFULL%/Ig>tmp.script
sed -e "s/\\/\\\\/Ig" tmp.script>sed.script
if "%ENVDIR%" == "%SRCDIR%" (
   echo /^^homedir/ s/%DESTHOMEFULL%/^&\%HOSTNAME%/Ig>tmp.script
   sed -e "s/\\/\\\\/Ig" tmp.script>>sed.script
   echo /^^EXE/ s/[^^ ]\{1,254\}\.exe/..\\^&/Ig>>sed.script
   echo /^^env/ s/[^^ ]\{1,254\}\.env/env\\^&/Ig>>sed.script
)
set file="%DESTDIR%\Config\*"
for %%f in ( %file% ) do ( 
   echo QCC30030I: Translating %%f agent configuration file to use the %PARM2%.
   type sed.script>>%TRCFILE%
   echo sed -f sed.script "%%f" to tmp.file>>%TRCFILE%
   sed -f sed.script "%%f">tmp.file
   echo sed rc = %errorlevel% >>%TRCFILE%
   type tmp.file>>%TRCFILE%
   echo del "%%f">>%TRCFILE%
   del "%%f">>%TRCFILE%
   echo move tmp.file "%%f">>%TRCFILE%
   move tmp.file "%%f">>%TRCFILE%
)


goto QMIGEXIT


rem 
rem Error messages for this script
rem 

:QCDIR_NVALID
   echo QCC30035E: The %PARM% directory must be a valid Quest Central Agent home directory.
   goto QMIGEXIT

:QCDIR_CREATERR
   set  RC=5
   echo QCC30040E: Unable to create %PARM% %NEWDIR%.
   goto QMIGEXIT

:QMIGHELP
   echo QCC30031I: Usage: %SCRIPT% %PARM1% %PARM2%
   echo %PARM1% is the home directory of Quest Central Agent whose configuration settings are to be migrated.
   echo %PARM2% is the home directory of Quest Central Agent where the configuration settings are to be migrated.
   goto QMIGEXIT

:QMIGEXIT
   if %RC% == 0 (
      echo QCC30032I: Migration of Quest Central Agent configuration settings successful.
   ) else (
      echo QCC30033E: Migration of Quest Central Agent configuration settings unsuccessful.
   )

if exist tmp.file ( del tmp.file )
if exist tmp.script (del tmp.script )
if exist sed.script (del sed.script )
echo QCC30034I: %SCRIPT% Finished.

prompt $p$g
